/*
 * Decompiled with CFR 0.152.
 */
package junitx.extensions;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitx.framework.Assert;

public abstract class EqualsHashCodeTestCase
extends TestCase {
    private Object eq1;
    private Object eq2;
    private Object eq3;
    private Object neq;
    private static final int NUM_ITERATIONS = 20;

    public EqualsHashCodeTestCase(String name) {
        super(name);
    }

    protected abstract Object createInstance() throws Exception;

    protected abstract Object createNotEqualInstance() throws Exception;

    protected void setUp() throws Exception {
        super.setUp();
        this.eq1 = this.createInstance();
        this.eq2 = this.createInstance();
        this.eq3 = this.createInstance();
        this.neq = this.createNotEqualInstance();
        try {
            junit.framework.Assert.assertNotNull("createInstance() returned null", this.eq1);
            junit.framework.Assert.assertNotNull("2nd createInstance() returned null", this.eq2);
            junit.framework.Assert.assertNotNull("3rd createInstance() returned null", this.eq3);
            junit.framework.Assert.assertNotNull("createNotEqualInstance() returned null", this.neq);
            Assert.assertNotSame(this.eq1, this.eq2);
            Assert.assertNotSame(this.eq1, this.eq3);
            Assert.assertNotSame(this.eq1, this.neq);
            Assert.assertNotSame(this.eq2, this.eq3);
            Assert.assertNotSame(this.eq2, this.neq);
            Assert.assertNotSame(this.eq3, this.neq);
            junit.framework.Assert.assertEquals("1st and 2nd equal instances of different classes", this.eq1.getClass(), this.eq2.getClass());
            junit.framework.Assert.assertEquals("1st and 3rd equal instances of different classes", this.eq1.getClass(), this.eq3.getClass());
            junit.framework.Assert.assertEquals("1st equal instance and not-equal instance of different classes", this.eq1.getClass(), this.neq.getClass());
        }
        catch (AssertionFailedError ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public final void testEqualsAgainstNewObject() {
        Object o = new Object();
        Assert.assertNotEquals(o, this.eq1);
        Assert.assertNotEquals(o, this.eq2);
        Assert.assertNotEquals(o, this.eq3);
        Assert.assertNotEquals(o, this.neq);
    }

    public final void testEqualsAgainstNull() {
        Assert.assertNotEquals("null vs. 1st", null, this.eq1);
        Assert.assertNotEquals("null vs. 2nd", null, this.eq2);
        Assert.assertNotEquals("null vs. 3rd", null, this.eq3);
        Assert.assertNotEquals("null vs. not-equal", null, this.neq);
    }

    public final void testEqualsAgainstUnequalObjects() {
        Assert.assertNotEquals("1st vs. not-equal", this.eq1, this.neq);
        Assert.assertNotEquals("2nd vs. not-equal", this.eq2, this.neq);
        Assert.assertNotEquals("3rd vs. not-equal", this.eq3, this.neq);
        Assert.assertNotEquals("not-equal vs. 1st", this.neq, this.eq1);
        Assert.assertNotEquals("not-equal vs. 2nd", this.neq, this.eq2);
        Assert.assertNotEquals("not-equal vs. 3rd", this.neq, this.eq3);
    }

    public final void testEqualsIsConsistentAcrossInvocations() {
        int i = 0;
        while (i < 20) {
            this.testEqualsAgainstNewObject();
            this.testEqualsAgainstNull();
            this.testEqualsAgainstUnequalObjects();
            this.testEqualsIsReflexive();
            this.testEqualsIsSymmetricAndTransitive();
            ++i;
        }
    }

    public final void testEqualsIsReflexive() {
        junit.framework.Assert.assertEquals("1st equal instance", this.eq1, this.eq1);
        junit.framework.Assert.assertEquals("2nd equal instance", this.eq2, this.eq2);
        junit.framework.Assert.assertEquals("3rd equal instance", this.eq3, this.eq3);
        junit.framework.Assert.assertEquals("not-equal instance", this.neq, this.neq);
    }

    public final void testEqualsIsSymmetricAndTransitive() {
        junit.framework.Assert.assertEquals("1st vs. 2nd", this.eq1, this.eq2);
        junit.framework.Assert.assertEquals("2nd vs. 1st", this.eq2, this.eq1);
        junit.framework.Assert.assertEquals("1st vs. 3rd", this.eq1, this.eq3);
        junit.framework.Assert.assertEquals("3rd vs. 1st", this.eq3, this.eq1);
        junit.framework.Assert.assertEquals("2nd vs. 3rd", this.eq2, this.eq3);
        junit.framework.Assert.assertEquals("3rd vs. 2nd", this.eq3, this.eq2);
    }

    public final void testHashCodeContract() {
        junit.framework.Assert.assertEquals("1st vs. 2nd", this.eq1.hashCode(), this.eq2.hashCode());
        junit.framework.Assert.assertEquals("1st vs. 3rd", this.eq1.hashCode(), this.eq3.hashCode());
        junit.framework.Assert.assertEquals("2nd vs. 3rd", this.eq2.hashCode(), this.eq3.hashCode());
    }

    public final void testHashCodeIsConsistentAcrossInvocations() {
        int eq1Hash = this.eq1.hashCode();
        int eq2Hash = this.eq2.hashCode();
        int eq3Hash = this.eq3.hashCode();
        int neqHash = this.neq.hashCode();
        int i = 0;
        while (i < 20) {
            junit.framework.Assert.assertEquals("1st equal instance", eq1Hash, this.eq1.hashCode());
            junit.framework.Assert.assertEquals("2nd equal instance", eq2Hash, this.eq2.hashCode());
            junit.framework.Assert.assertEquals("3rd equal instance", eq3Hash, this.eq3.hashCode());
            junit.framework.Assert.assertEquals("not-equal instance", neqHash, this.neq.hashCode());
            ++i;
        }
    }
}

