/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import junitx.framework.Assert;
import junitx.framework.AssertionFailedError;

public class FileAssert {
    private FileAssert() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertEquals(String message, File expected, File actual) {
        Assert.assertNotNull(expected);
        Assert.assertNotNull(actual);
        Assert.assertTrue("File does not exist [" + expected.getAbsolutePath() + "]", expected.exists());
        Assert.assertTrue("File does not exist [" + actual.getAbsolutePath() + "]", actual.exists());
        Assert.assertTrue("Expected file not readable", expected.canRead());
        Assert.assertTrue("Actual file not readable", actual.canRead());
        FileInputStream eis = null;
        FileInputStream ais = null;
        try {
            try {
                eis = new FileInputStream(expected);
                ais = new FileInputStream(actual);
                BufferedReader expData = new BufferedReader(new InputStreamReader(eis));
                BufferedReader actData = new BufferedReader(new InputStreamReader(ais));
                Assert.assertNotNull(message, expData);
                Assert.assertNotNull(message, actData);
                FileAssert.assertEquals(message, expData, actData);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                eis.close();
                ais.close();
                throw throwable;
            }
            eis.close();
            ais.close();
            {
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e);
        }
    }

    public static void assertEquals(File expected, File actual) {
        FileAssert.assertEquals(null, expected, actual);
    }

    protected static void assertEquals(String message, Reader expected, Reader actual) {
        Assert.assertNotNull(message, expected);
        Assert.assertNotNull(message, actual);
        LineNumberReader expReader = new LineNumberReader(expected);
        LineNumberReader actReader = new LineNumberReader(actual);
        Assert.assertNotNull(message, expReader);
        Assert.assertNotNull(message, actReader);
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        try {
            while (true) {
                if (!expReader.ready() && !actReader.ready()) {
                    return;
                }
                String expLine = expReader.readLine();
                String actLine = actReader.readLine();
                if (expLine == null && actLine == null) {
                    return;
                }
                int line = expReader.getLineNumber() + 1;
                if (expReader.ready()) {
                    if (actReader.ready()) {
                        Assert.assertEquals(formatted + "Line [" + line + "]", expLine, actLine);
                        continue;
                    }
                    Assert.fail(formatted + "Line [" + line + "] expected <" + expLine + "> but was <EOF>");
                    continue;
                }
                if (actReader.ready()) {
                    Assert.fail(formatted + "Line [" + line + "] expected <EOF> but was <" + actLine + ">");
                    continue;
                }
                Assert.assertEquals(formatted + "Line [" + line + "]", expLine, actLine);
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e);
        }
    }

    public static void assertBinaryEquals(File expected, File actual) {
        FileAssert.assertBinaryEquals(null, expected, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertBinaryEquals(String message, File expected, File actual) {
        Assert.assertNotNull(message, expected);
        Assert.assertNotNull(message, actual);
        Assert.assertTrue("File does not exist [" + expected.getAbsolutePath() + "]", expected.exists());
        Assert.assertTrue("File does not exist [" + actual.getAbsolutePath() + "]", actual.exists());
        Assert.assertTrue("Expected file not readable", expected.canRead());
        Assert.assertTrue("Actual file not readable", actual.canRead());
        FileInputStream eis = null;
        FileInputStream ais = null;
        try {
            block12: {
                block11: {
                    try {
                        eis = new FileInputStream(expected);
                        ais = new FileInputStream(actual);
                        Assert.assertNotNull(message, expected);
                        Assert.assertNotNull(message, actual);
                        byte[] expBuff = new byte[8192];
                        byte[] actBuff = new byte[8192];
                        long pos = 0L;
                        int expLength = eis.read(expBuff, 0, 8192);
                        int actLength = ais.read(actBuff, 0, 8192);
                        if (expLength < actLength) {
                            Assert.fail("actual file is longer");
                        }
                        if (expLength > actLength) {
                            Assert.fail("actual file is shorter");
                        }
                        if (expLength == 0) {
                            Object var14_11 = null;
                            break block11;
                        }
                        int i = 0;
                        while (true) {
                            if (i >= expBuff.length) {
                                pos += (long)expBuff.length;
                                break block12;
                            }
                            if (expBuff[i] != actBuff[i]) {
                                String formatted = "";
                                if (message != null) {
                                    formatted = message + " ";
                                }
                                Assert.fail(formatted + "files differ at byte " + (pos + (long)i + 1L));
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_13 = null;
                        eis.close();
                        ais.close();
                        throw throwable;
                    }
                }
                eis.close();
                ais.close();
                return;
            }
            Object var14_12 = null;
            eis.close();
            ais.close();
            return;
        }
        catch (IOException e) {
            throw new AssertionFailedError(e);
        }
    }
}

