/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.util.List;
import junit.framework.AssertionFailedError;
import junitx.framework.Assert;

public class ListAssert {
    private ListAssert() {
    }

    public static void assertEquals(List expected, List actual) {
        ListAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, List expected, List actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            return;
        }
        int ii = 0;
        while (ii < expected.size()) {
            ListAssert.assertContains(message, actual, expected.get(ii));
            ++ii;
        }
        String formatted = "[length]";
        if (message != null) {
            formatted = message + " " + formatted;
        }
        Assert.assertEquals(formatted, expected.size(), actual.size());
    }

    public static void assertContains(List actual, Object value) {
        ListAssert.assertContains(null, actual, value);
    }

    public static void assertContains(String message, List actual, Object value) {
        Assert.assertNotNull(message, actual);
        if (actual.contains(value)) {
            return;
        }
        ListAssert.failNotContains(message, actual, value);
    }

    private static void failNotContains(String message, List actual, Object value) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        StringBuffer listcontent = new StringBuffer();
        int ii = 0;
        while (ii < actual.size() - 1) {
            listcontent.append(actual.get(ii)).append(", ");
            ++ii;
        }
        listcontent.append(actual.get(actual.size() - 1));
        throw new AssertionFailedError(formatted + "expecting <" + value + "> in <" + listcontent.toString() + ">");
    }
}

