/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import junitx.framework.Assert;

public class ObjectAssert {
    private ObjectAssert() {
    }

    public static void assertInstanceOf(String message, Class expected, Object actual) {
        if (expected.isInstance(actual)) {
            return;
        }
        ObjectAssert.failInstanceOf(message, expected, actual);
    }

    public static void assertInstanceOf(Class expected, Object actual) {
        ObjectAssert.assertInstanceOf(null, expected, actual);
    }

    public static void assertNotInstanceOf(String message, Class expected, Object actual) {
        if (!expected.isInstance(actual)) {
            return;
        }
        ObjectAssert.failNotInstanceOf(message, expected);
    }

    public static void assertNotInstanceOf(Class expected, Object actual) {
        ObjectAssert.assertNotInstanceOf(null, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        ObjectAssert.assertSame(null, expected, actual);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        ObjectAssert.failSame(message, expected, actual);
    }

    public static void assertNotSame(Object expected, Object actual) {
        ObjectAssert.assertNotSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        if (expected != actual) {
            return;
        }
        ObjectAssert.failNotSame(message, expected);
    }

    private static void failInstanceOf(String message, Class expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected instance of class: <" + expected.getName() + "> but was of class: <" + actual.getClass().getName() + ">");
    }

    private static void failNotInstanceOf(String message, Class expected) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not instance of class: <" + expected.getName() + ">");
    }

    private static void failSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected same as : <" + expected + "> but was <" + actual + ">");
    }

    private static void failNotSame(String message, Object expected) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not same as : <" + expected + ">");
    }
}

