/*
 * Decompiled with CFR 0.152.
 */
package ToyIP;

import ToyIP.AppletRenderer;
import ToyIP.GeneratorExecuteAction;
import ToyIP.GeneratorLoadScriptAction;
import ToyIP.InstanceAddConstraintAction;
import ToyIP.InstanceConstraintsTableModel;
import ToyIP.InstanceResetAction;
import ToyIP.TextAreaPrintStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppletSettings
extends JApplet
implements TableModelListener,
ChangeListener {
    protected JTabbedPane tabbedPane;
    protected JTextArea scriptText;
    protected JComboBox scriptCombo;
    protected InstanceConstraintsTableModel instanceConstraints;
    protected JTextArea detailsText;
    protected AppletRenderer renderer;

    public AppletSettings(AppletRenderer appletRenderer) {
        this.renderer = appletRenderer;
    }

    public void goToNextTab() {
        if (this.tabbedPane.getSelectedIndex() + 1 < this.tabbedPane.getComponentCount()) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getSelectedIndex() + 1);
        }
    }

    public void setScriptText(String string) {
        this.scriptText.setText(string);
    }

    public String getScriptText() {
        return this.scriptText.getText();
    }

    public void instanceReset() {
        this.instanceConstraints.clear();
    }

    public void instanceAddConstraint(double d, double d2, double d3, double d4) {
        Double[] doubleArray = new Double[]{d, d2, d3, d4};
        this.instanceConstraints.addLine(doubleArray);
    }

    public List<Double[]> getConstraints() {
        return this.instanceConstraints.getData();
    }

    public int getScriptComboValue() {
        return this.scriptCombo.getSelectedIndex();
    }

    protected JComponent makePaneGenerator() {
        JPanel jPanel = new JPanel();
        GeneratorLoadScriptAction generatorLoadScriptAction = new GeneratorLoadScriptAction(this);
        this.scriptText = new JTextArea(generatorLoadScriptAction.getScript(0));
        this.scriptText.setEditable(true);
        this.scriptText.setFont(new Font("Courier New", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this.scriptText);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new GeneratorExecuteAction(this));
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel();
        this.scriptCombo = new JComboBox<String>(generatorLoadScriptAction.getScriptNames());
        this.scriptCombo.setEditable(false);
        this.scriptCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        JButton jButton2 = new JButton(generatorLoadScriptAction);
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(this.scriptCombo);
        jPanel3.add(jButton2);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        return jPanel;
    }

    protected JComponent makePaneInstance() {
        JPanel jPanel = new JPanel();
        this.instanceConstraints = new InstanceConstraintsTableModel(this);
        JTable jTable = new JTable(this.instanceConstraints){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 == 0 || n2 == 4) {
                    component.setBackground(Color.lightGray);
                }
                return component;
            }
        };
        jTable.getModel().addTableModelListener(this);
        jTable.setAutoResizeMode(3);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        jTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        JTextField jTextField = new JTextField();
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        jTextField.setEditable(false);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        defaultCellEditor.setClickCountToStart(1);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        jTable.getColumnModel().getColumn(4).setPreferredWidth(20);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new InstanceResetAction(this));
        JButton jButton2 = new JButton(new InstanceAddConstraintAction(this));
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        return jPanel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.renderer.updatePolyhedron(this.instanceConstraints.getData());
    }

    protected JComponent makePaneOptions() {
        JPanel jPanel = new JPanel();
        JCheckBox jCheckBox = new JCheckBox("Display the integral grid");
        JCheckBox jCheckBox2 = new JCheckBox("Use transparency");
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jCheckBox);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jCheckBox2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        return jPanel;
    }

    protected JComponent makePaneAlgorithm() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setMinimumSize(new Dimension(500, 500));
        return jScrollPane;
    }

    protected JComponent makePaneDetails() {
        this.detailsText = new JTextArea(5, 5);
        this.detailsText.setEditable(false);
        this.detailsText.setForeground(Color.lightGray);
        this.detailsText.setBackground(Color.black);
        this.detailsText.setFont(new Font("Courier New", 0, 12));
        String string = "\n Toy IP Solver developed by Jakub Marecek (jakub@marecek.cz).\n\n";
        string = string + "Using java.library.path=" + System.getProperty("java.library.path") + "\n";
        this.detailsText.setText(string);
        TextAreaPrintStream textAreaPrintStream = new TextAreaPrintStream(this.detailsText, System.out);
        System.setOut(textAreaPrintStream);
        JScrollPane jScrollPane = new JScrollPane(this.detailsText);
        jScrollPane.setMinimumSize(new Dimension(500, 500));
        return jScrollPane;
    }

    @Override
    public void init() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Generator", this.makePaneGenerator());
        this.tabbedPane.addTab("Instance", this.makePaneInstance());
        this.tabbedPane.addTab("Display", this.makePaneOptions());
        this.tabbedPane.addTab("Algorithm", this.makePaneAlgorithm());
        this.tabbedPane.addTab("Details", this.makePaneDetails());
        this.tabbedPane.setSelectedIndex(1);
        this.add(this.tabbedPane);
    }
}

