/*
 * Decompiled with CFR 0.152.
 */
package vtk.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import vtk.util.VtkPanelContainer;
import vtk.vtkActor2D;
import vtk.vtkCanvas;
import vtk.vtkImageData;
import vtk.vtkImageViewer;
import vtk.vtkPanel;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkTextActor;
import vtk.vtkTextMapper;

public class ImageViewerPanel
extends JComponent
implements VtkPanelContainer {
    private CustomVtkPanel customVtkPanel = new CustomVtkPanel();
    private vtkTextMapper textMapper = new vtkTextMapper();

    public ImageViewerPanel() {
        vtkTextActor vtkTextActor2 = new vtkTextActor();
        vtkTextActor2.SetInput("?");
        vtkTextActor2.SetMapper(this.textMapper);
        vtkTextActor2.SetPosition(0.1, 0.9);
        this.customVtkPanel.GetRenderer().AddActor(vtkTextActor2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.customVtkPanel, "Center");
    }

    public vtkTextMapper getTextMapper() {
        return this.textMapper;
    }

    public vtkActor2D getImageViewerActor2D() {
        return this.customVtkPanel.imageViewer.GetActor2D();
    }

    public void setImageViewerInput(vtkImageData vtkImageData2) {
        this.customVtkPanel.imageViewer.SetInput(vtkImageData2);
    }

    public int getImageViewerZSlice() {
        return this.customVtkPanel.imageViewer.GetZSlice();
    }

    public void setImageViewerZSlice(int n) {
        this.customVtkPanel.imageViewer.SetZSlice(n);
        this.customVtkPanel.repaint();
    }

    public void setImageViewerColorWindow(double d) {
        this.customVtkPanel.imageViewer.SetColorWindow(d);
    }

    public void setImageViewerColorLevel(double d) {
        this.customVtkPanel.imageViewer.SetColorLevel(d);
    }

    public vtkRenderWindowInteractor getRenderInteractor() {
        return this.customVtkPanel.imageViewer.GetRenderWindow().GetInteractor();
    }

    public vtkPanel getRenWin() {
        return this.customVtkPanel;
    }

    public synchronized void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (n > 0 && n2 > 0) {
            this.customVtkPanel.setSize(n, n2);
            if (!this.customVtkPanel.isWindowSet()) {
                this.customVtkPanel.addWindowSetObserver(new Observer(){

                    public void update(Observable observable, Object object) {
                        Dimension dimension = ImageViewerPanel.this.customVtkPanel.getSize();
                        ImageViewerPanel.this.customVtkPanel.setSize(dimension.width, dimension.height);
                    }
                });
            }
        }
    }

    public void repaint() {
        super.repaint();
        if (this.customVtkPanel != null) {
            this.customVtkPanel.repaint();
        }
    }

    private static class CustomVtkPanel
    extends vtkCanvas {
        private vtkImageViewer imageViewer = new vtkImageViewer();

        CustomVtkPanel() {
            Dimension dimension = super.getSize();
            this.rw = this.imageViewer.GetRenderWindow();
            this.rw.SetSize(dimension.width, dimension.height);
            this.ren = this.imageViewer.GetRenderer();
            this.imageViewer.GetRenderWindow().SetInteractor(this.iren);
        }
    }
}

