/*
 * Decompiled with CFR 0.152.
 */
package ToyIP;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import vtk.util.VtkColors;
import vtk.util.VtkPanelContainer;
import vtk.util.VtkPanelUtil;
import vtk.vtkActor;
import vtk.vtkCubeSource;
import vtk.vtkDataObject;
import vtk.vtkGlyph3D;
import vtk.vtkHull;
import vtk.vtkMapper;
import vtk.vtkPanel;
import vtk.vtkPointSet;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataAlgorithm;
import vtk.vtkPolyDataMapper;
import vtk.vtkRenderer;
import vtk.vtkSphereSource;
import vtk.vtkTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkUnstructuredGrid;
import vtk.vtkVectorText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletRenderer
extends JComponent
implements VtkPanelContainer {
    private vtkPanel renWin = new vtkPanel();

    public vtkActor generateBase() {
        vtkCubeSource vtkCubeSource2 = new vtkCubeSource();
        vtkCubeSource2.SetXLength(1.5);
        vtkCubeSource2.SetYLength(0.01);
        vtkCubeSource2.SetZLength(1.5);
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInput(vtkCubeSource2.GetOutput());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper(vtkPolyDataMapper2);
        vtkActor2.SetPosition(0.5, -0.09, 0.5);
        return vtkActor2;
    }

    public vtkActor generatePolyhedron(List<Double[]> list) {
        vtkPoints vtkPoints2 = new vtkPoints();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    boolean bl = true;
                    for (Double[] doubleArray : list) {
                        if (!(doubleArray[0] * (double)i + doubleArray[1] * (double)j + doubleArray[2] * (double)k > doubleArray[3])) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    vtkPoints2.InsertNextPoint(i, j, k);
                }
            }
        }
        vtkPolyData vtkPolyData2 = new vtkPolyData();
        vtkPolyData2.SetPoints(vtkPoints2);
        vtkHull vtkHull2 = new vtkHull();
        vtkHull2.SetInput(vtkPolyData2);
        for (Double[] doubleArray : list) {
            System.out.print("Rendering a constraint ");
            System.out.print(doubleArray[0].toString() + "x + ");
            System.out.print(doubleArray[1].toString() + "y + ");
            System.out.print(doubleArray[2].toString() + "z <= ");
            System.out.println(doubleArray[3].toString());
            vtkHull2.AddPlane(doubleArray[0], doubleArray[1], doubleArray[2], doubleArray[3]);
        }
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInput(vtkHull2.GetOutput());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper(vtkPolyDataMapper2);
        vtkActor2.SetPosition(0.0, 0.0, 0.0);
        vtkActor2.GetProperty().SetDiffuseColor(VtkColors.BANNANA);
        vtkActor2.GetProperty().SetOpacity(0.6);
        return vtkActor2;
    }

    public vtkActor generateIntegers(List<Double[]> list) {
        Object object;
        Object object2;
        Object object4;
        Object object5;
        vtkPoints vtkPoints2 = new vtkPoints();
        Object object6 = 0;
        while ((Integer)object6 < 10) {
            object5 = 0;
            while ((Integer)object5 < 10) {
                object4 = 0;
                while ((Integer)object4 < 10) {
                    boolean bl = false;
                    for (Double[] object32 : list) {
                        if (!(object32[0] * (double)((Integer)object6).intValue() + object32[1] * (double)((Integer)object5).intValue() + object32[2] * (double)((Integer)object4).intValue() <= object32[3])) continue;
                        bl = true;
                    }
                    if (bl) {
                        vtkPoints2.InsertNextPoint(((Integer)object6).intValue(), ((Integer)object5).intValue(), ((Integer)object4).intValue());
                        System.out.println("Adding point [" + ((Integer)object6).toString() + ", " + ((Integer)object5).toString() + ", " + ((Integer)object4).toString() + "]");
                    }
                    object2 = object4;
                    object = object4 = Integer.valueOf((Integer)object4 + 1);
                }
                object4 = object5;
                object2 = object5 = Integer.valueOf((Integer)object5 + 1);
            }
            object5 = object6;
            object4 = object6 = Integer.valueOf((Integer)object6 + 1);
        }
        object6 = new vtkUnstructuredGrid();
        ((vtkUnstructuredGrid)object6).Allocate(1, 1);
        ((vtkPointSet)object6).SetPoints(vtkPoints2);
        object5 = new vtkSphereSource();
        ((vtkSphereSource)object5).SetRadius(0.04);
        ((vtkSphereSource)object5).SetPhiResolution(10);
        ((vtkSphereSource)object5).SetThetaResolution(10);
        object4 = new vtkPolyData();
        ((vtkPointSet)object4).SetPoints(vtkPoints2);
        object2 = new vtkGlyph3D();
        ((vtkPolyDataAlgorithm)object2).SetInput((vtkDataObject)object4);
        ((vtkGlyph3D)object2).SetSource(((vtkPolyDataAlgorithm)object5).GetOutput());
        object = new vtkPolyDataMapper();
        ((vtkPolyDataMapper)object).SetInput(((vtkPolyDataAlgorithm)object2).GetOutput());
        ((vtkMapper)object).ScalarVisibilityOff();
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper((vtkMapper)object);
        vtkActor2.GetProperty().SetDiffuseColor(VtkColors.RED);
        vtkActor2.GetProperty().SetOpacity(1.0);
        return vtkActor2;
    }

    public void updatePolyhedron(List<Double[]> list) {
        vtkRenderer vtkRenderer2 = this.renWin.GetRenderer();
    }

    public vtkActor generateLabel() {
        vtkVectorText vtkVectorText2 = new vtkVectorText();
        vtkVectorText2.SetText("Toy Integer Programming Solver");
        vtkTransform vtkTransform2 = new vtkTransform();
        vtkTransform2.Identity();
        vtkTransform2.Translate(-0.2, 0.0, 1.25);
        vtkTransform2.Scale(0.05, 0.05, 0.05);
        vtkTransformPolyDataFilter vtkTransformPolyDataFilter2 = new vtkTransformPolyDataFilter();
        vtkTransformPolyDataFilter2.SetTransform(vtkTransform2);
        vtkTransformPolyDataFilter2.SetInput(vtkVectorText2.GetOutput());
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInput(vtkTransformPolyDataFilter2.GetOutput());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper(vtkPolyDataMapper2);
        return vtkActor2;
    }

    public AppletRenderer() {
        VtkPanelUtil.setSize(this.renWin, 500, 500);
        vtkRenderer vtkRenderer2 = this.renWin.GetRenderer();
        vtkRenderer2.AddActor(this.generateBase());
        vtkRenderer2.AddActor(this.generateLabel());
        vtkRenderer2.SetBackground(VtkColors.SLATE_GREY);
        vtkRenderer2.GetActiveCamera().Dolly(1.2);
        vtkRenderer2.GetActiveCamera().Azimuth(30.0);
        vtkRenderer2.GetActiveCamera().Elevation(20.0);
        vtkRenderer2.ResetCameraClippingRange();
        this.setLayout(new BorderLayout());
        this.add((Component)this.renWin, "Center");
    }

    @Override
    public vtkPanel getRenWin() {
        return this.renWin;
    }
}

