/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import junitx.framework.Assert;

public class StringAssert {
    private StringAssert() {
    }

    public static void assertContains(String substring, String actual) {
        StringAssert.assertContains(null, substring, actual);
    }

    public static void assertContains(String message, String substring, String actual) {
        Assert.assertNotNull(substring);
        if (actual != null && actual.indexOf(substring) >= 0) {
            return;
        }
        StringAssert.failContains(message, substring, actual);
    }

    public static void assertNotContains(String substring, String actual) {
        StringAssert.assertNotContains(null, substring, actual);
    }

    public static void assertNotContains(String message, String substring, String actual) {
        if (actual == null && substring != null || actual != null && substring == null || actual != null && actual.indexOf(substring) < 0) {
            return;
        }
        StringAssert.failNotContains(message, substring, actual);
    }

    public static void assertStartsWith(String substring, String actual) {
        StringAssert.assertStartsWith(null, substring, actual);
    }

    public static void assertStartsWith(String message, String substring, String actual) {
        Assert.assertNotNull(substring);
        if (actual != null && actual.startsWith(substring)) {
            return;
        }
        StringAssert.failStartsWith(message, substring, actual);
    }

    public static void assertNotStartsWith(String substring, String actual) {
        StringAssert.assertNotStartsWith(null, substring, actual);
    }

    public static void assertNotStartsWith(String message, String substring, String actual) {
        if (actual == null && substring != null || actual != null && substring == null || actual != null && !actual.startsWith(substring)) {
            return;
        }
        StringAssert.failNotStartsWith(message, substring);
    }

    public static void assertEndsWith(String substring, String actual) {
        StringAssert.assertEndsWith(null, substring, actual);
    }

    public static void assertEndsWith(String message, String substring, String actual) {
        Assert.assertNotNull(substring);
        if (actual != null && actual.endsWith(substring)) {
            return;
        }
        StringAssert.failEndsWith(message, substring, actual);
    }

    public static void assertNotEndsWith(String substring, String actual) {
        StringAssert.assertNotEndsWith(null, substring, actual);
    }

    public static void assertNotEndsWith(String message, String substring, String actual) {
        if (actual == null && substring != null || actual != null && substring == null || actual != null && !actual.endsWith(substring)) {
            return;
        }
        StringAssert.failNotEndsWith(message, substring);
    }

    private static void failContains(String message, String substring, String actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected containing: <" + substring + "> but was: <" + actual + ">");
    }

    private static void failNotContains(String message, String substring, String actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not containing: <" + substring + "> but was: <" + actual + ">");
    }

    private static void failStartsWith(String message, String substring, String actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected starting with: <" + substring + "> but was: <" + actual + ">");
    }

    private static void failNotStartsWith(String message, String substring) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not starting with: <" + substring + ">");
    }

    private static void failEndsWith(String message, String substring, String actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected ending with: <" + substring + "> but was: <" + actual + ">");
    }

    private static void failNotEndsWith(String message, String substring) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not ending with: <" + substring + ">");
    }
}

