/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import junitx.framework.Assert;
import junitx.framework.ObjectAssert;

public class ThrowableAssert {
    private ThrowableAssert() {
    }

    public static void assertEquals(String message, Throwable expected, Throwable actual) {
        ObjectAssert.assertInstanceOf(message, expected.getClass(), actual);
        if (message == null) {
            Assert.assertEquals("[message]", expected.getMessage(), actual.getMessage());
            Assert.assertEquals("[localized message]", expected.getLocalizedMessage(), actual.getLocalizedMessage());
        } else {
            Assert.assertEquals(message + " [message]", expected.getMessage(), actual.getMessage());
            Assert.assertEquals(message + " [localized message]", expected.getLocalizedMessage(), actual.getLocalizedMessage());
        }
    }

    public static void assertEquals(Throwable expected, Throwable actual) {
        ThrowableAssert.assertEquals(null, expected, actual);
    }

    public static void assertSimilar(String message, Throwable expected, Throwable actual) {
        ObjectAssert.assertInstanceOf(message, expected.getClass(), actual);
        if (expected.getMessage() == null) {
            throw new IllegalArgumentException("String to search cannot be <null>");
        }
        if (actual.getMessage() != null && actual.getMessage().indexOf(expected.getMessage()) >= 0) {
            return;
        }
        if (actual.getLocalizedMessage() != null && actual.getLocalizedMessage().indexOf(expected.getMessage()) >= 0) {
            return;
        }
        ThrowableAssert.failContainsMessage(message, expected, actual);
    }

    public static void assertSimilar(Throwable expected, Throwable actual) {
        ThrowableAssert.assertSimilar(null, expected, actual);
    }

    private static void failContainsMessage(String message, Throwable expected, Throwable actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        if (actual.getMessage().equals(actual.getLocalizedMessage())) {
            Assert.fail(formatted + "Expected containing <" + expected.getMessage() + "> in <" + actual.getMessage() + ">");
        } else {
            Assert.fail(formatted + "Expected containing <" + expected.getMessage() + "> in <" + actual.getMessage() + "> or <" + actual.getLocalizedMessage() + "> (localized)");
        }
    }
}

