/*
 * Decompiled with CFR 0.152.
 */
package vtk.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class VtkUtil {
    private static final String VTK_DATA_ROOT = "VTK_DATA_ROOT";

    private VtkUtil() {
    }

    public static String getEnvironmentVariable(String string) throws RuntimeException {
        String string2;
        block6: {
            string2 = System.getProperty(VTK_DATA_ROOT);
            if (string2 != null) {
                return string2;
            }
            String string3 = System.getProperty("os.name");
            String[] stringArray = null;
            stringArray = string3.startsWith("Windows 9") || string3.equalsIgnoreCase("Windows ME") ? new String[]{"command.com", "/C", "set"} : (string3.startsWith("Windows") ? new String[]{"cmd.exe", "/C", "set"} : new String[]{"/usr/bin/printenv"});
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                StreamGrabber streamGrabber = new StreamGrabber(process.getErrorStream());
                StreamGrabber streamGrabber2 = new StreamGrabber(process.getInputStream());
                streamGrabber.start();
                streamGrabber2.start();
                int n = process.waitFor();
                if (n == 0) {
                    streamGrabber2.join();
                    Properties properties = VtkUtil.extractProperties(streamGrabber2.getData());
                    string2 = properties.getProperty(VTK_DATA_ROOT);
                    if (string2 == null) {
                        throw new RuntimeException("Property '" + string + "' not defined. " + "Use command line option '-D" + string + "=value' to define 'VTK_DATA_ROOT'.");
                    }
                    break block6;
                }
                throw new RuntimeException("Cannot extract environment variable 'VTK_DATA_ROOT'. Lookup thread terminated with code " + n + ".");
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error extracting environment variable: '" + string + "'.", iOException);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Error extracting environment variable: '" + string + "'.", interruptedException);
            }
        }
        return string2;
    }

    private static Properties extractProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            properties.setProperty(string2.trim(), string3.trim());
        }
        return properties;
    }

    public static String getVtkDataRoot() throws RuntimeException {
        return VtkUtil.getEnvironmentVariable(VTK_DATA_ROOT);
    }

    public static void printProperties() {
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + " : " + properties.getProperty(string));
        }
    }

    private static class StreamGrabber
    extends Thread {
        InputStream inputStream;
        ArrayList lines = new ArrayList();

        StreamGrabber(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.lines.add(string);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public String[] getData() {
            return this.lines.toArray(new String[this.lines.size()]);
        }
    }
}

