package ToyIP;

import ToyIP.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;


class TextAreaPrintStream extends PrintStream {
  private JTextArea textArea;
  public TextAreaPrintStream(JTextArea area, OutputStream out) {
    super(out);
    textArea = area;
  }
  public void println(String string) {
    textArea.append( string + "\n");
  }
  public void print(String string) {
    textArea.append(string);
  }
}


class AppletSettings extends JApplet implements TableModelListener, ChangeListener  {

  protected JTabbedPane tabbedPane;
  protected JTextArea scriptText;
  protected JComboBox scriptCombo;
  protected InstanceConstraintsTableModel instanceConstraints;
  protected JTextArea detailsText;
  protected AppletRenderer renderer;

  public AppletSettings(AppletRenderer r) {
    renderer = r;
  }

  public void goToNextTab() {
    if (tabbedPane.getSelectedIndex() + 1 < tabbedPane.getComponentCount()) {
      tabbedPane.setSelectedIndex(tabbedPane.getSelectedIndex() + 1);
    }
  }

  public void setScriptText(String text) {
    scriptText.setText(text);
  }

  public String getScriptText() {
    return scriptText.getText();
  }

  public void instanceReset() {
    instanceConstraints.clear();
  }

  public void instanceAddConstraint(double x, double y, double z, double rhs) {
    Double line[] = {x, y, z, rhs};
    instanceConstraints.addLine(line);
  }

  public java.util.List< Double[] > getConstraints() {
    return instanceConstraints.getData();
  }

  public int getScriptComboValue() {
    return scriptCombo.getSelectedIndex();
  }

  protected JComponent makePaneGenerator() {
    final JPanel panel = new JPanel();
    GeneratorLoadScriptAction loadScript = new GeneratorLoadScriptAction(this);
    scriptText = new JTextArea(loadScript.getScript(0));
    scriptText.setEditable(true);
    scriptText.setFont(new Font("Courier New", Font.PLAIN, 12));
    JScrollPane scrollPane = new JScrollPane(scriptText);

    JPanel executePane = new JPanel();
    JButton buttonExecute = new JButton(new GeneratorExecuteAction(this));
    executePane.setLayout(new BoxLayout(executePane, BoxLayout.LINE_AXIS));
    executePane.add(Box.createHorizontalGlue());
    executePane.add(buttonExecute);

    JPanel loadPane = new JPanel();
    scriptCombo = new JComboBox(loadScript.getScriptNames());
    scriptCombo.setEditable(false);
    scriptCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
    JButton buttonLoad = new JButton(loadScript);
    loadPane.setLayout(new BoxLayout(loadPane, BoxLayout.LINE_AXIS));
    loadPane.add(scriptCombo);
    loadPane.add(buttonLoad);

    panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
    panel.add(loadPane);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));
    panel.add(scrollPane);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));
    panel.add(executePane);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));
    return panel;
  }

  protected JComponent makePaneInstance() {
    final JPanel panel = new JPanel();
    instanceConstraints = new InstanceConstraintsTableModel(this);
    final JTable table = new JTable(instanceConstraints) {
      public Component prepareRenderer(TableCellRenderer r, int row, int col) {
        Component c = super.prepareRenderer(r, row, col);
        if ((col == 0) || (col == 4)) { c.setBackground(Color.lightGray); }
        return c;
      }
    };
    table.getModel().addTableModelListener(this);
    table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
    table.setPreferredScrollableViewportSize(new Dimension(500, 300));
    table.getColumnModel().getColumn(0).setPreferredWidth(10);

    JTextField textField = new JTextField();
    textField.setBorder(BorderFactory.createEmptyBorder());
    textField.setEditable(false);
    DefaultCellEditor editor = new DefaultCellEditor(textField);
    editor.setClickCountToStart(1);
    table.getColumnModel().getColumn(0).setPreferredWidth(100);
    table.getColumnModel().getColumn(4).setPreferredWidth(20);

    JScrollPane scrollPane = new JScrollPane(table);
    JPanel addConstraintPane = new JPanel();
    JButton clearButton = new JButton(new InstanceResetAction(this));
    JButton addButton = new JButton(new InstanceAddConstraintAction(this));
    addConstraintPane.setLayout(new BoxLayout(addConstraintPane, BoxLayout.LINE_AXIS));
    addConstraintPane.add(Box.createHorizontalGlue());
    addConstraintPane.add(clearButton);
    addConstraintPane.add(addButton);

    panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
    panel.add(scrollPane);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));
    panel.add(addConstraintPane);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));

    return panel;
  }

  public void stateChanged(ChangeEvent e) {
  /*
    if (tabbedPane.getSelectedIndex() == 2) {
      JSlider slider = (JSlider) e.getSource();
      if (!slider.getValueIsAdjusting()) {
        subdivCanvasMag = (int) slider.getValue();
      }
      fireCanvasDataChanged();
    }
  */
  }


  public void tableChanged(TableModelEvent e) {
    renderer.updatePolyhedron(instanceConstraints.getData());
  }

  protected JComponent makePaneOptions() {
    final JPanel panel = new JPanel();
    JCheckBox integersBox = new JCheckBox("Display the integral grid");
    JCheckBox transparencyBox = new JCheckBox("Use transparency");

    panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
    panel.add(integersBox);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));
    panel.add(transparencyBox);
    panel.add(Box.createRigidArea(new Dimension(0, 2)));
    return panel;
  }

  protected JComponent makePaneAlgorithm() {
    JScrollPane scrollPane = new JScrollPane();
    scrollPane.setMinimumSize(new Dimension(500, 500));
    return scrollPane;
  }

  protected JComponent makePaneDetails() {
    detailsText = new JTextArea(5, 5);
    detailsText.setEditable(false);
    detailsText.setForeground(Color.lightGray);
    detailsText.setBackground(Color.black);
    detailsText.setFont(new Font("Courier New", Font.PLAIN, 12));

    String txt = "\n Toy IP Solver developed by Jakub Marecek (jakub@marecek.cz).\n\n";
    txt += "Using java.library.path=" + System.getProperty("java.library.path") + "\n"; 
    detailsText.setText(txt);

    TextAreaPrintStream redirect = new TextAreaPrintStream(detailsText, System.out);
    System.setOut(redirect);
    JScrollPane scrollPane = new JScrollPane(detailsText);
    scrollPane.setMinimumSize(new Dimension(500, 500));
    return scrollPane;
  }

  public void init() {
    tabbedPane = new JTabbedPane();
    tabbedPane.addTab("Generator", makePaneGenerator());
    tabbedPane.addTab("Instance", makePaneInstance());
    tabbedPane.addTab("Display", makePaneOptions());
    tabbedPane.addTab("Algorithm", makePaneAlgorithm());
    tabbedPane.addTab("Details", makePaneDetails());
    tabbedPane.setSelectedIndex(1);
    add(tabbedPane);
  }
}