package ToyIP;

import ToyIP.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class GeneratorLoadScriptAction extends AbstractAction {

  protected AppletSettings app;
  protected java.util.List<String> scriptNames;
  protected java.util.List<String> scriptTexts;

  public GeneratorLoadScriptAction(AppletSettings a) {
    super("Load script");
    app = a;

    scriptNames = new LinkedList<String> ();
    scriptTexts = new LinkedList<String> ();

    scriptNames.add("The Unit Cube");
    String cubeText =
      "# Type in a Python script that fills ax, ay, az, and b with doubles\n\n";
    cubeText += "ax = []\nay = []\naz = []\nb =[]\n\n";
    cubeText += "for i in range(0, 2): \n";
    cubeText += "  for j in range(0, 2): \n";
    cubeText += "    for k in range(0, 2): \n";
    cubeText += "      ax.append(i+0.1)\n";
    cubeText += "      ay.append(j+0.1)\n";
    cubeText += "      az.append(k+0.1)\n";
    cubeText += "      b.append(1)\n";
    scriptTexts.add(cubeText);

    scriptNames.add("Four Random Hyperplanes");
    String randomText =
      "# Type in a Python script that fills ax, ay, az, and b with doubles\n\n";
    randomText += "from java.util import Random\n";
    randomText += "rng = Random()\n\n";
    randomText += "ax = []\nay = []\naz = []\nb=[]\n\n";
    randomText += "for i in range(0, 4):\n";
    randomText += "  ax.append(rng.nextDouble())\n";
    randomText += "  ay.append(rng.nextDouble())\n";
    randomText += "  az.append(rng.nextDouble())\n";
    randomText += "  b.append(rng.nextDouble())\n";
    scriptTexts.add(randomText);

  }

  public String[] getScriptNames() {
    return scriptNames.toArray(new String[0]);
  }

  public String getScript(int i) {
    return scriptTexts.get(i);
  }

  public void actionPerformed(ActionEvent ae) {
    app.setScriptText(getScript(app.getScriptComboValue()));
  }
}

