/*** EXAMPLE: Riemann's zeta-function                             ***/
/*** v1.0, July 2002, questions to tim.dokchitser@durham.ac.uk    ***/
/***                                                              ***/
/*** type \rex-zeta or read("ex-zeta") at pari prompt to run this ***/

default(realprecision,28);        \\ set working precision; used throughout

                            \\ initialize L-function parameters
conductor = 1;              \\ exponential factor = 1/sqrt(Pi)
gammaV    = [0];            \\ list of gamma-factors
weight    = 1;              \\ L(s)=sgn*L(weight-s)
sgn       = 1;              \\ sign in the functional equation
Lpoles    = [1];            \\ poles of zeta(s) with Re(s)>0.5 
Lresidues = [-1];           \\ and residues in there
aaa=(n->1);
initall([conductor,gammaV,weight,sgn,Lpoles,Lresidues]);initLdata(aaa);      \\ Initalized L-series with coefficients a(k)

            \\ initialize the package; all coeffs equal to 1


print("EXAMPLE: L(s)=zeta(s), Riemann zeta function");
print("         with ",default(realprecision)," digits precision");
print("Verifying functional equation. Error: ",errprint(checkfeq()));
print("zeta(2)    = ",L(2),     "   using the package");
print("           = ",L(2,1.1), "   using a different cutoff point");
print("           = ",zeta(2),  "   built-in pari zeta(s) function");
print("           = ",Pi^2/6,   "   Pi^2/6");
