import numpy

N = 100
L = numpy.ndarray(shape=(N, N))
for i in range(N):
    x = 2*i/N - 1.0
    a, b = 1/2-x^2 , 3/4 - 2*x^2
    if a < b:
        L[i, a*N:b*N] = .5


def solve_heat(initial_conditions, dx, dt, iter):
    cur = initial_conditions.copy()
    next = numpy.zeros_like(initial_conditions)
    M, N = cur.shape
    for count in range(iter):
        print count
        for i in range(1, M-1):
            for j in range(1, N-1):
                step = cur[i-1,j] + cur[i+1,j] + cur[i,j-1] + cur[i,j+1] - 4*cur[i,j]
                next[i,j] = cur[i,j] + dt*step/dx^2
        cur, next = next, cur
    return cur
    
